﻿using System;
using System.ComponentModel;
using System.Web.UI;
using System.Web.UI.WebControls.WebParts;
using System.Xml;
using Microsoft.SharePoint.WebControls;
using Microsoft.Web.CommandUI;

namespace ContextualWebPart.ContextualWebPart
{
   [ToolboxItemAttribute(false)]
   public class ContextualWebPart : WebPart, IWebPartPageComponentProvider
   {
      private string ctxGroup = @"
        <ContextualGroup
          Color=""Orange""
          Command=""CtxTab.EnableCtxGroup""
          Id=""Ribbon.CtxGroup""
          Title=""Kontextuelle Gruppe""
          Sequence=""501""
          ContextualGroupId=""CtxTabGroup"">
          <Tab
            Id=""Ribbon.CtxTab""
            Title=""Kontextueller Tab""
            Sequence=""501"">
            <Scaling
              Id=""Ribbon.CtxTab.Scaling"">
              <MaxSize
                Id=""Ribbon.CtxTab.MaxSize""
                GroupId=""Ribbon.CtxTab.Group""
                Size=""TwoLarge""/>
            </Scaling>
            <Groups Id=""Ribbon.CtxTab.Groups"">
             <Group
               Id=""Ribbon.CtxTab.Group""
               Title=""Gruppe im Ribbon""
               Sequence=""5""
               Template=""Ribbon.Templates.CustomTemplate"">
               <Controls
                 Id=""Ribbon.CtxTab.Controls"">
                 <Button
                   Id=""Ribbon.CtxTab.ButtonOne""
                   Command=""CtxTab.Alert""
                   Sequence=""5""
                   LabelText=""Button Eins""
                   Image32by32=""/_layouts/images/ctoa32.png""
                   TemplateAlias=""c1""/>
                 <Button
                   Id=""Ribbon.CtxTab.ButtonTwo""
                   Command=""CtxTab.Alert""
                   Sequence=""15""
                   LabelText=""Button Zwei""
                   Image32by32=""/_layouts/images/searchlogo.png""
                   TemplateAlias=""c2""/>
               </Controls>
             </Group>
           </Groups>
         </Tab>
        </ContextualGroup>";

      private string ctxTemplate = @"
        <GroupTemplate Id=""Ribbon.Templates.CustomTemplate"">
          <Layout Title=""TwoLarge"" LayoutTitle=""TwoLarge"">
            <Section Alignment=""Top"" Type=""OneRow"">
                <Row>
                    <ControlRef DisplayMode=""Large""
                                TemplateAlias=""c1"" />
                </Row>
            </Section>
            <Section Alignment=""Top"" Type=""OneRow"">
                <Row>
                    <ControlRef DisplayMode=""Large""
                                TemplateAlias=""c2"" />
                </Row>
            </Section>
          </Layout>
        </GroupTemplate>";

      public string DelayScript
      {
         get
         {
            string webPartPageComponentId = SPRibbon.GetWebPartPageComponentId(this);
            return @"
                <script type=""text/javascript"">
                //<![CDATA[

                function _addPageComponent()
                {
                    var component = new CtxWebPart.PageComponent('" + webPartPageComponentId + @"');
                    SP.Ribbon.PageManager.get_instance().addPageComponent(component);
                }

                function _registerPageComponent()
                {
                    SP.SOD.registerSod(""CtxWebPartExtensions.js"", ""\/_layouts\/ContextWebPart\/CtxWebPartExtensions.js"");
                    SP.SOD.executeFunc(""CtxWebPartExtensions.js"", ""ContextualWebPart.PageComponent"", _addPageComponent);
                }
                SP.SOD.executeOrDelayUntilScriptLoaded(_registerPageComponent, ""sp.ribbon.js"");
                //]]>
                </script>";
         }
      }

      protected override void OnPreRender(EventArgs e)
      {
         base.OnPreRender(e);

         RegisterRibbonExtension();

         ClientScriptManager clientScript =
             this.Page.ClientScript;
         clientScript.RegisterClientScriptBlock(
             this.GetType(), "CtxWebPart", this.DelayScript);
      }

      private void RegisterRibbonExtension()
      {
         Ribbon ribbon = SPRibbon.GetCurrent(this.Page);

         // XmlDocument erzeugen
         XmlDocument ribbonExtensions = new XmlDocument();

         // Ribbon-Definition der kontextuellen Gruppe laden
         ribbonExtensions.LoadXml(ctxGroup);

         // Ribbon-Definition zur Gruppe der kontextuellen Tabs hinzufügen
         ribbon.RegisterDataExtension(
             ribbonExtensions.FirstChild,
             "Ribbon.ContextualTabs._children");

         // Ribbon-Definition des Template registrieren
         ribbonExtensions.LoadXml(this.ctxTemplate);
         ribbon.RegisterDataExtension(
             ribbonExtensions.FirstChild,
             "Ribbon.Templates._children");
      }

      public WebPartContextualInfo WebPartContextualInfo
      {
         get
         {
            // Objekt des Rückgabewerts
            WebPartContextualInfo ctxInfo = new WebPartContextualInfo();

            // Erzeuge eine neue kontextuelle Gruppe
            WebPartRibbonContextualGroup ctxGroup = new WebPartRibbonContextualGroup();
            ctxGroup.Id = "Ribbon.CtxGroup";
            ctxGroup.Command = "CtxTab.EnableCtxGroup";
            ctxGroup.VisibilityContext = "CustomContextualTab.CustomVisibilityContext";

            // Erzeuge einen kontextuellen Tab
            WebPartRibbonTab tab = new WebPartRibbonTab();
            tab.Id = "Ribbon.CtxTab";
            tab.VisibilityContext = "CustomContextualTab.CustomVisibilityContext";

            // Füge dem WebPartContextualInfo den Tab sowie die Gruppe hinzu
            ctxInfo.ContextualGroups.Add(ctxGroup);
            ctxInfo.Tabs.Add(tab);
            ctxInfo.PageComponentId = SPRibbon.GetWebPartPageComponentId(this);

            return ctxInfo;
         }
      }
   }
}